/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.entities.bolloom;

import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBolloomEntity
extends Entity {
    private static final DataParameter<Float> ORIGIN_X = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGIN_Y = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ORIGIN_Z = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ANGLE = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> DESIRED_ANGLE = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SWAY = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TICKS_EXISTED = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> UNTIED = EntityDataManager.func_187226_a(AbstractBolloomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private float prevVineAngle;
    private float prevAngle;

    protected AbstractBolloomEntity(EntityType<?> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ORIGIN_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ORIGIN_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DESIRED_ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SWAY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(UNTIED, (Object)false);
        this.field_70180_af.func_187214_a(TICKS_EXISTED, (Object)0);
    }

    public void func_70071_h_() {
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.prevVineAngle = this.getVineAngle();
        this.prevAngle = this.getAngle();
        this.setSway(MathHelper.func_76126_a((float)((float)(0.06283185307179587 * (double)this.getTicksExisted()))) * 0.5f);
        this.updatePositionAndMotion(MathHelper.func_76126_a((float)(-this.getAngle())), MathHelper.func_76134_b((float)(-this.getAngle())));
        if (!this.field_70170_p.field_72995_K) {
            if (this.getTicksExisted() % 45 == 0) {
                this.setDesiredAngle((float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI));
            }
            if (this.func_226278_cu_() >= 254.0 && this.isUntied()) {
                this.onBroken(true);
                this.func_70106_y();
            }
            float dangle = this.getDesiredAngle() - this.getAngle();
            while ((double)dangle > Math.PI) {
                dangle = (float)((double)dangle - Math.PI * 2);
            }
            while ((double)dangle <= -Math.PI) {
                dangle = (float)((double)dangle + Math.PI * 2);
            }
            if (Math.abs(dangle) <= 0.1f) {
                this.setAngle(this.getAngle() + dangle);
            } else if (dangle > 0.0f) {
                this.setAngle(this.getAngle() + 0.03f);
            } else {
                this.setAngle(this.getAngle() - 0.03f);
            }
        }
        this.updateUntied();
        this.func_70066_B();
        if (this.shouldIncrementTicksExisted()) {
            this.incrementTicksExisted();
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("UNTIED", this.isUntied());
        compound.func_74776_a("ORIGIN_X", this.getOriginX());
        compound.func_74776_a("ORIGIN_Y", this.getOriginY());
        compound.func_74776_a("ORIGIN_Z", this.getOriginZ());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setUntied(compound.func_74767_n("UNTIED"));
        if (compound.func_150297_b("ORIGIN_X", 5) && compound.func_150297_b("ORIGIN_Y", 5) && compound.func_150297_b("ORIGIN_Z", 5)) {
            this.setOrigin(compound.func_74760_g("ORIGIN_X"), compound.func_74760_g("ORIGIN_Y"), compound.func_74760_g("ORIGIN_Z"));
        } else {
            this.setUntied(true);
        }
    }

    public void setOrigin(float x, float y, float z) {
        this.field_70180_af.func_187227_b(ORIGIN_X, (Object)Float.valueOf(x));
        this.field_70180_af.func_187227_b(ORIGIN_Y, (Object)Float.valueOf(y));
        this.field_70180_af.func_187227_b(ORIGIN_Z, (Object)Float.valueOf(z));
    }

    public float getOriginX() {
        return ((Float)this.field_70180_af.func_187225_a(ORIGIN_X)).floatValue();
    }

    public float getOriginY() {
        return ((Float)this.field_70180_af.func_187225_a(ORIGIN_Y)).floatValue();
    }

    public float getOriginZ() {
        return ((Float)this.field_70180_af.func_187225_a(ORIGIN_Z)).floatValue();
    }

    public void setAngle(float degree) {
        this.field_70180_af.func_187227_b(ANGLE, (Object)Float.valueOf(degree));
    }

    public float getAngle() {
        return ((Float)this.field_70180_af.func_187225_a(ANGLE)).floatValue();
    }

    public void setDesiredAngle(float angle) {
        this.field_70180_af.func_187227_b(DESIRED_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getDesiredAngle() {
        return ((Float)this.field_70180_af.func_187225_a(DESIRED_ANGLE)).floatValue();
    }

    public float getVineAngle() {
        return (float)Math.atan(this.getSway() / 2.0f);
    }

    public void setSway(float sway) {
        this.field_70180_af.func_187227_b(SWAY, (Object)Float.valueOf(sway));
    }

    public float getSway() {
        return ((Float)this.field_70180_af.func_187225_a(SWAY)).floatValue();
    }

    public void setUntied(boolean untied) {
        this.field_70180_af.func_187227_b(UNTIED, (Object)untied);
    }

    public boolean isUntied() {
        return (Boolean)this.field_70180_af.func_187225_a(UNTIED);
    }

    public void incrementTicksExisted() {
        this.field_70180_af.func_187227_b(TICKS_EXISTED, (Object)(this.getTicksExisted() + 1));
    }

    public int getTicksExisted() {
        return (Integer)this.field_70180_af.func_187225_a(TICKS_EXISTED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getVineAnimation(float partialTicks) {
        return new float[]{MathHelper.func_219799_g((float)partialTicks, (float)this.prevVineAngle, (float)this.getVineAngle()), MathHelper.func_219799_g((float)partialTicks, (float)this.prevAngle, (float)this.getAngle())};
    }

    public abstract void updatePositionAndMotion(double var1, double var3);

    public abstract void updateUntied();

    public boolean shouldIncrementTicksExisted() {
        return true;
    }

    public void onBroken(boolean dropFruit) {
        this.func_184185_a(SoundEvents.field_211414_dn, 1.0f, 1.0f);
        this.doParticles();
    }

    protected void doParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, ((Block)EEBlocks.BOLLOOM_PARTICLE.get()).func_176223_P()), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 1.5, this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return this.func_190530_aW() && source != DamageSource.field_76380_i && source != DamageSource.field_191291_g;
    }

    protected Vector3d func_213308_a(Vector3d pos) {
        return Vector3d.field_186680_a;
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity && this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entityIn)), 0.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBroken(true);
        }
        return true;
    }

    public void func_70024_g(double x, double y, double z) {
        if (!this.isUntied()) {
            return;
        }
        super.func_70024_g(x, y, z);
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(5.0);
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB getCollisionBox(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

